package com.ejie.p06b.manager;


import java.util.ArrayList;

import com.ejie.p06b.dao.P06BGeneralDAO;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.log.P06BLog;

/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * 
 * Manager para la gestin de las FCA's
 * 
 * Fecha de creacin: (28/05/07)
 */
public class P06BGeneralManager {
	
	static private P06BGeneralManager instance = null;

	public static P06BGeneralManager getInstance() {
	     if (instance == null) {
	          synchronized (P06BGeneralManager.class) {
	          		if (instance == null) {
	                     instance = new P06BGeneralManager();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene una lista de provincias FCA's
    *
    * @param Idioma de la aplicacion
    * @return ArrayList
    * 			Lista de objetos provincias P06BFCAGeneralDatatype
    * @throws P06BException
    */
	public ArrayList obtenerProvincias(String idioma) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerProvincias(idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerProvincias: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
		
	/**
    * Obtiene una lista de aseguradoras FCA's
    *
    * @param Idioma de la aplicacion
    * @return ArrayList
    * 			Lista de objetos aseguradoras P06B23T00Datatype
    * @throws P06BException
    */
	public ArrayList obtenerAseguradoras(String idioma) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerAseguradoras(idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerAseguradoras: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
			
	/**
	* Mtodo que obtiene la localidad FCA a partir de la localidad NORA
	* Eliminar cuando se convierta el cdigo de localidad
	* Supone que la columna NUMERO en la tabla de entidades de NORA
	* corresponde con la localidad FCA.
    *
    * @param localidadNORA
    * @return localidadFCA
    * @throws P06BException
    */
	public String sustituirLocNORAPorLocFCA(String localidadNORA){
		try {
			return P06BGeneralDAO.getInstance().sustituirLocNORAPorLocFCA(localidadNORA);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - sustituirLocNORAPorLocFCA: "+e.getMessage());
		}
		return "";
	}
				
	
	/**
    * Obtiene una lista de municipios FCA's
    * 
    * @param Codigo de la provincia cuyos municipios desean obtenerse
    * @return ArrayList
    * 			Lista de objetos municipios P06BFCAGeneralDatatype
    * 
    * @throws P06BException
    */
	public ArrayList obtenerMunicipios(int codProvincia) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerMunicipios(codProvincia);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerMunicipios: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene una lista de localidades FCA's
    * 
    * @param Codigo de la provincia cuyas localidades desean obtenerse
    * @param Codigo del municipio cuyas localidades desean obtenerse
    * 
    * @return ArrayList
    * 			Lista de objetos municipios P06BFCAGeneralDatatype
    * 
    * @throws P06BException
    */
	public ArrayList obtenerLocalidades(int codProvincia, int codMunicipio) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerLocalidades(codProvincia,codMunicipio);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerLocalidades: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene una lista de localidades FCA's
    * 
    * @param Codigo de la provincia cuyos CP desean obtenerse
    * @param Codigo del municipio cuyos CP desean obtenerse
    * @param Codigo de la localidad cuyos CP desean obtenerse
    * 
    * @return ArrayList
    * 			Lista de String con la lista de codigos postales de la localidad
    * 
    * @throws P06BException
    */
	public ArrayList obtenerCodPostales(int codProvincia, int codMunicipio, int codLocalidad) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerCodPostales(codProvincia,codMunicipio,codLocalidad);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerCodPostales: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene una lista de paises FCA's
    *
    * @param Idioma de la aplicacion
    * @return ArrayList
    * 			Lista de objetos provincias P06BFCAGeneralDatatype
    * @throws P06BException
    */
	public ArrayList obtenerPaises(String idioma) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerPaises(idioma);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerPaises: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene el nombre de la provincia
    *
    * @param Idioma de la aplicacion
    * @param codProv cdigo de la provincia
    * @return String
    * 			nombre de la provincia
    * @throws P06BException
    */
	public String obtenerNomProv(String idioma, String codProv) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerNomProv(idioma, codProv);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerNomProv: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	
	/**
    * Obtiene el nombre del municipio
    *
    * @param codProv cdigo de la provincia
    * @param codMun cdigo del municipio
    * @return String
    * 			nombre del municipio
    * @throws P06BException
    */
	public String obtenerNomMun(String codProv, String codMun) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerNomMun(codProv, codMun);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerNomMun: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}


	/**
    * Obtiene el nombre de la localidad
    *
    * @param codProv cdigo de la provincia
    * @param codMun cdigo del municipio
    * @param codLoc cdigo de la localidad
    * @return String
    * 			nombre de la localidad
    * @throws P06BException
    */
	public String obtenerNomLoc(String codProv, String codMun, String codLoc) throws P06BException{
		try {
			return P06BGeneralDAO.getInstance().obtenerNomLoc(codProv, codMun, codLoc);
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BGeneralManager - obtenerNomLoc: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}
	

}
